; ******************************************************************************
; Dimmer  12/2009  HoWL
; Version fr PIC 16F737 mit 3 Hardware PWM
;
;
; I2CFail: mal return rausnehmen
;  
; Programmiereingang: Jumper auf Masse - programmieren ein
;
; 30.6.1020
; watchdog aktiviert
; ******************************************************************************

   LIST   	p=16F737      
   include 	"P16F737.inc"      

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES
	
; Configuration
 
   __CONFIG    _CONFIG1,  _MCLR_OFF &_CP_OFF & _CCP2_RB3 & _DEBUG_OFF & _VBOR_2_0 & _BOREN_0 & _PWRTE_OFF & _WDT_ON & _HS_OSC 


	include	"16BITS.INC"

 CBLOCK	0x0020

	Flags
 	R0L,R0H,R1L,R1H,R2L,R2H	; Arbeitsregister Wait
	_Red 
	_Blue 
	_Green 
	_REG_A,_REG_B     		; Arbeitsregister 16BITS.INC  
	 
 	state				; fading status
	max					; Helligkeit
	mode, mode_alt		; modus

 	gr_e				; empfangene gruppe
	co_e				; empfangenes kommando
	ir_adr				; IR Adresse

	cycl_1				; zhler
	cycl_2				; zhler
	cycl_3				; zhler fe empfangsbitschleife
	data_1				; datenpuffer low-teil
	data_2				; datenpuffer high-teil

	timeout
	counterL,counterH	; counter fr fading
	
	brightnessL,brightnessH
		
	eeprom_counter,eeprom_counterH
	adc_counter,adc_counterH	; Abfrage adc
	env					; Umgebungshelligkeit
	
 endc

; ------------------------------------------------------------------------------
; aus allen Bnken erreichbar
 CBLOCK 0x0070
 		STATUS_TEMP
 		W_TEMP
		TEMP, TEMP1
	 
		LC01ADDR
		LC01DATA 
 endc

; ------------------------------------------------------------------------------
#define	LED			PORTC,1		; Status LED


#define	red			PORTB,3		; Farben
#define	green		PORTC,2
#define	blue		PORTB,5

#define	ir			PORTA,4		; Infrarot Eingang
#define	PROG		PORTA,5		; IR Adresse Prog
     
#define	TIMEDOUT	Flags,0		; Infrarot Timeout
#define	STOP		Flags,1		; STOP Taste gedrckt
#define	CHANGED		Flags,2		; nderungen zum speichern


#define LC01CTRLIN 	0xa0 		; I2C EEprom Adresse schreiben
#define LC01CTRLOUT 0xa1 		; I2C EEprom Adresse lesen


; ******************************************************************************     
 
; ******************************************************************************     
  	 	org   0x0000         
  	   
  		 	goto   Init      


; ******************************************************************************     
; IRQ
			org   0x0004
		
			MOVWF W_TEMP 			;Copy W to TEMP register
			SWAPF STATUS, W 		;Swap status to be saved into W
			CLRF STATUS 			;bank 0, regardless of current bank, Clears IRP,RP1,RP0
			MOVWF STATUS_TEMP 		;Save status to bank zero STATUS_TEMP register
;
;(ISR) ;Insert user code here
;
			SWAPF STATUS_TEMP, W 	;Swap STATUS_TEMP register into W
									;(sets bank to original state)
			MOVWF STATUS 			;Move W into STATUS register
			SWAPF W_TEMP, F 		;Swap W_TEMP
			SWAPF W_TEMP, W 		;Swap W_TEMP into W
			retfie
     
; ******************************************************************************     

Init:	 	bsf    	STATUS,   RP0      	; select bank 1    
	
  	 		movlw   b'01100000'     	; set external osc 
  	 		movwf   OSCCON 

  	 		movlw   0x07 
  	 		movwf   CMCON         		; turn comparators off 
   	
 	 	 	movlw   0xff	      		; set PortA all inputs 
 	 	 	movwf   TRISA
      	
 	 	  	movlw   b'11010111'      	; set PortB 
 	 	 	movwf   TRISB          
   
 	 	 	movlw   b'11111001'      	; set PortC  RC1= LED,  RC3/4 I2C
 	 	 	movwf   TRISC         	

; Ausgnge aus
			bcf		red
			bcf		green
			bcf		blue
			bcf		LED
		   	
; PWM Einstellungen   	
			movlw	0xff				; PWM Period
			movwf	PR2

			bcf     STATUS,   RP0      	;select bank 0
		
; alles aus		
			clrf	PORTB
			clrf	PORTC
		
	
; duty cycle PWM 1-3	
			movlw	0x00				; duty cycle 
			movwf	CCPR1L
			movwf	CCPR2L
		
			bsf    	STATUS,   RP0      	;select bank 1
			movwf	CCPR3L
			bcf     STATUS,   RP0      	;select bank 0 

; PWM Modus
			movlw	0x0f
			movwf	CCP1CON				; PWM Modus
			movwf	CCP2CON				; PWM Modus

			bsf    	STATUS,   RP0      	;select bank 1
			movwf	CCP3CON				; PWM Modus
			bcf     STATUS,   RP0      	;select bank 0 
	
	
			movlw	0x15				; TMR2 on / kein Vorteiler
			movwf	T2CON
	
	
; I2C Einstellungen
		    bsf     STATUS, RP0         ; Bank 1 

			clrf    SSPSTAT             ; Disable SMBus inputs
		    bsf     SSPSTAT,SMP			; disable slew rate control

		    movlw   .25               	; clock  
		    movwf   SSPADD              ; 100kHz I2C clock

			clrf	SSPCON2				; clear control bits

		    bcf     STATUS, RP0         ; Bank 0 
    
		    movlw   B'00101000'         ; master mode, clock=Fosc/(4*(SSPADD+1)) 
		    movwf   SSPCON              ; Enable SSP, select I2C Master Mode
	    
		    bcf     PIR1,SSPIF          ; Clear SSP interrupt flag
		    bcf     PIR2,BCLIF          ; Clear Bit Collision flag
	

				
; Voreinstellung alles aus
			movlw	0x00
			movwf	_Red
			movwf	_Green
			movwf	_Blue

			clrf	state
			
			bcf		STOP
	
			movlw	0x00				; "Timer" fortschaltung
			movwf	counterH
			movlw	0xff
			movwf	counterL

			INIT16	eeprom_counter,0	; verzgertes schreiben in EEprom
			INIT16	adc_counter,0		; Zeitintervall fr ADC lesen

; ADC 
 		   	bsf    ADCON0, ADON    		; ADC einschalten ADON=1 

; ADC-Eingang AN3 auswhlen 0011
 		   	bcf    ADCON0, CHS3    
 		   	bcf    ADCON0, CHS2     
 	  	 	bsf    ADCON0, CHS1     
 		   	bsf    ADCON0, CHS0     
    
; ADC speed fr 10 MHz einstellen  (101)
 		   	bsf    ADCON0, ADCS2     
 		   	bcf    ADCON0, ADCS1     
 		   	bsf    ADCON0, ADCS0     

; Daten linksbndig 
 		   	bsf    STATUS,RP0   	; Bank1 
 		   	bcf    ADCON1, ADFM    	; ADFM=0 
    
; Voltage Reference
			bcf		ADCON1,VCFG1	; VREF- connected to VSS    
			bcf		ADCON1,VCFG0	; VREF+ connected to VDD    
	
			bsf		ADCON1,PCFG3	; AN3 (1011)
			bcf		ADCON1,PCFG2
			bsf		ADCON1,PCFG1
			bsf		ADCON1,PCFG0
		    
 		   	bcf    STATUS,RP0   	; Bank0 

		

; -----------------------------------------------	
; I2C EEprom auslesen

; modus
			movlw	0x01	
			movwf	LC01ADDR
			call	I2CRead
			movwf	mode	
	
		
; Helligkeit der LED

			movlw	0x02	
			movwf	LC01ADDR
			call	I2CRead
			movwf	max		
			movlw	.63
			andwf	max,f

			movlw	0x00
			subwf	max,w
			bnz		a1

			movlw	.63
			movwf	max
			
a1:
	
; Umgebung Empfindlichkeit
			movlw	0x03	
			movwf	LC01ADDR
			call	I2CRead
			movwf	env		
		
		
; Infrarot Adresse
			movlw	0x04	
			movwf	LC01ADDR
			call	I2CRead
			movwf	ir_adr	


; mode_alt		
			movlw	0x05	
			movwf	LC01ADDR
			call	I2CRead
			movwf	mode_alt	
		
	 

; init Ende Besttigung	
			bsf		LED
			call	WaitMs500
			bcf		LED		
		
			call	adc_run			; einmalig fr Start auslesen Helligkeit
			
;*******************************************************************************

MainLoop:
			clrwdt

			call	setLED
	
			call	ir_polling
				
			call	write_eeprom
	
			call	adc

			goto	MainLoop

; ******************************************************************************
write_eeprom:
			btfss	CHANGED				; gab es nderung ?
			return						; nein
		
			DEC16	eeprom_counter		; counter schon null
			btfss	STATUS,Z
			return						; nein

			bcf		CHANGED
		

; alle Werte schreiben
			movlw	0x01				; mode				
			movwf	LC01ADDR
			movfw	mode
			movwf	LC01DATA
			call 	I2CWrite
		
			call	WaitMs10
			call	WaitMs10
		
			movlw	0x05				; mode_alt !!!!!!				
			movwf	LC01ADDR
			movfw	mode_alt
			movwf	LC01DATA
			call 	I2CWrite
		
			call	WaitMs10
			call	WaitMs10

			movlw	0x02				; Helligkeit
			movwf	LC01ADDR
			movfw	max
			movwf	LC01DATA
			call 	I2CWrite

			call	WaitMs10
			call	WaitMs10

			movlw	0x03				; Umgebungs Licht Schwelle
			movwf	LC01ADDR
			movfw	env
			movwf	LC01DATA
			call 	I2CWrite
		
			call	WaitMs10
			call	WaitMs10
		
write_eeprom_adr:		
			movlw	0x04				; Infrarot Adresse
			movwf	LC01ADDR
			movfw	ir_adr
			movwf	LC01DATA
			call 	I2CWrite
		
			return
; ******************************************************************************
; Helligkeitswerte lesen
; zu hell dann mode_alt = mode & mode .99 (aus)
; dunkel  dann mode = mode_alt
adc:		DEC16	adc_counter		; Verzgerung
			btfss	STATUS,Z
			return
adc_run:		
			bsf     ADCON0, 2     	; ADC starten 
		
adc_wait:	BTFSC   ADCON0, 2    	; ist der ADC fertig? 
			goto	adc_wait		; nein

	; ADRESH enthlt obere 8 Bit 		
	
			movfw	env	
			subwf	ADRESH,w
			bc		adc1			; einschalten

		
			movfw	env	
			movwf	TEMP
			movlw	.10				; Hysterese ber 10 Werte
			subwf	TEMP,w
			subwf	ADRESH,w		
			bnc		adc0			; ausschalten

			goto	adc2
		

adc0:		movlw	.99				; nicht wenn schon ist
			subwf	mode,w
			bz		adc2

			movfw	mode			; mode sichern
			movwf	mode_alt
			movlw	.99				; ausschalten
			movwf	mode

			goto	adc2

adc1:		movfw	mode_alt		; vorherigen mode wieder herstellen
			movwf	mode
  
    	
adc2:  		return

;*******************************************************************************
;* sprut
;*
;* pollen der leitung
;*
;* RC-5 bus pollen
;* empfangene signale auf LED ausgeben

ir_polling:

	 	 
		bsf		TIMEDOUT
		
		call	empfangen	;IR empfangen
		btfsc	TIMEDOUT
		return
		

	
; Programmiermodus ?		
		btfsc	PROG		; Adresse programmieren ?
		goto	ir_p1		; nein
		
		movfw	gr_e
		movwf	ir_adr
		call	write_eeprom_adr	; Werte wegschreiben
		

ir_p1:
;		btfss	PROG		; Programmiermodus ?
;		goto	ir_p2		; ja, dann Gruppenadresse nicht prfen
		
; Gruppenadresse prfen

		movfw	ir_adr
		subwf	gr_e,w
		bz		ir_p2
		return				; falsche Adresse	
		
ir_p2:

; -------------------------------------
		movlw	.10			; Tasten 0-9 Mode
		subwf	co_e,w
		bc		cc1

		movfw	co_e		; Kommando
		movwf	mode
		movwf	mode_alt	; merken fr Helligkeitssteuerung

		goto	ack_led
		
; -------------------------------------
cc1:	movlw	.17			; "leiser=dunkler"
		subwf	co_e,w
		bnz		cc2

		movlw	0x00		; Untergrenze erreicht ?
		subwf	max,w
		btfsc	STATUS,Z
		return				; kein ACK
		decf	max,f

		goto	ack_led

; -------------------------------------
cc2:	movlw	.16			; "lauter=heller"
		subwf	co_e,w
		bnz		cc3

		movlw	.64			; Obergrenze erreicht ?
		subwf	max,w
		btfsc	STATUS,Z
		return				; kein ACK
		
		incf	max,f	
		
		goto	ack_led

; -------------------------------------
cc3:	movlw	.54			; "stop"
		subwf	co_e,w
		bnz		cc4

		bsf		STOP
		
		goto	ack_led

; -------------------------------------
cc4:	movlw	.53			; "play"
		subwf	co_e,w
		bnz		cc5

		bcf		STOP
		
		goto	ack_led

; -------------------------------------
cc5:	movlw	.32			; "Kanal + = nchster Mode"
		subwf	co_e,w
		bnz		cc6

		movlw	.10		; Obergrenze erreicht ?
		subwf	mode,w
		btfsc	STATUS,Z
		return				; kein ACK
		incf	mode,f
		goto	ack_led

; -------------------------------------
cc6:	movlw	.33			; "Kanal - = vorheriger Mode"
		subwf	co_e,w
		bnz		cc7

		movlw	0x00		; untergrenze erreicht ?
		subwf	mode,w
		btfsc	STATUS,Z
		return				; kein ACK
		decf	mode,f	
		goto	ack_led
	 

; -------------------------------------
cc7:	movlw	.50			; "nach links spulen - umgebung niedriger"
		subwf	co_e,w
		bnz		cc8

		movlw	0x00		; untergrenze erreicht ?
		subwf	env,w
		btfsc	STATUS,Z
		return				; kein ACK
		decf	env,f	
		goto	ack_led
	

cc8:	movlw	.52			; "nach rechts spulen - umgebung hher"
		subwf	co_e,w
		bnz		cc10

		movlw	.254		; Obergrenze erreicht ?
		subwf	mode,w
		btfsc	STATUS,Z
		return				; kein ACK
		incf	env,f
		goto	ack_led

cc10:
; weitere ...

; unbekanntes Kommando
cc_end:
	
		return
		
; -------------------------------------
ack_led:
		INIT16	eeprom_counter,0		; Zhler zum Schreiben zurcksetzen
		bsf		CHANGED
		bsf		LED
		call	WaitMs10
		bcf		LED
		return


;*******************************************************************************
; einen RC-5-code mit polling empfangen
;
; gruppencode: gr_e
; commando   : co_e
; vor dem aufruf wenigstens 1 ms low pegel abwarten !!
empfangen:

		movlw	0xff
		movwf	timeout

e1:		decf	timeout,f
		btfsc	STATUS,Z
		return

		btfss	ir
		goto	e1	; warten auf high

empfangenL:

		movlw	0xff
		movwf	timeout
eL1:	decf	timeout,f
		btfsc	STATUS,Z
		return

		btfsc	ir
		goto	eL1			; warten auf low, 1/2-Bit vorbei

		bcf		TIMEDOUT
		bcf		INTCON,GIE	; interupts sperren

		call	viertelbit	; 1/4 nach bitmitte

		btfsc	ir
		goto	Fehler		; war nur spike

		clrf	data_1		; datenpuffer lschen
		clrf	data_2
		movlw	D'13'		; 13 bits bei syncronisation
		movwf	cycl_3
; 3/4 nach bitanfang wird wert gelesen, invertiert
; und eingeschrieben
; dann wird auf die flanke gewartet, die das neue bit einleitet
; nach der flanke wird bis 3/4 bit gewartet und dann neu begonnen

		call	halbbit		; 1/4 des 2. Bits

nextbit
		rlf	data_1,f
		rlf	data_2,f
		bcf	data_1, 0		; angenommen leitung ist low (0) 
		btfsc	ir			; leitung abfragen
		bsf	data_1, 0		; leitung ist high (1), in datenpuffer

; warten auf pegelnderung
		call	anders		; Bitmitte

		call	viertelbit	; 3/4 Bit
		call	halbbit		; 1/4 nach bitanfang
		decfsz	cycl_3,f	; alle 13 bit + startbit empfangen?
		goto	nextbit

		movfw	data_1
		movwf	co_e
		bcf	co_e, 6
		bcf	co_e, 7			; auf 6 bit begrenzen

		rlf	data_1,f
		rlf	data_2,f	
		rlf	data_1,f
		rlf	data_2,f		; gruppe nach data_2
		movfw	data_2
		movwf	gr_e
		bcf	gr_e, 7
		bcf	gr_e, 6
		bcf	gr_e, 5			; auf 5 bit begrenzen
	
; 2. stoppbit zum 7 commandobit machen
		btfss	data_2, 6
		bsf	co_e, 6			;2. Stoppbit invers  -> 7.commandobit

		movfw	co_e
Fehler
;		bsf	INTCON,GIE		; interrupts wieder erlauben
	
		return

;**************************************************************
; warten darauf, dass die leitung RA4 dem inversen wert in 'data_1, 0' entspricht
;
; zeitbegrenzt auf ca. ein halbes bit
;**************************************************************
anders
		movlw	D'22'		; 22 x (10 MHz)

;		movlw	D'9'		; 9 x  ( 4 MHz)
		movwf	cycl_1
a_1:		movlw	D'32'		; 100 takte
		movwf	cycl_2
a_2:		decfsz	cycl_2,f	
		goto	a_2

		btfsc	ir		; portpegel abfragen
		goto	a_high
a_low:				; portpegel ist 0
		btfsc	data_1, 0	; ist sollwert=0 ?
		return			; high-low flanke
		goto	a_weiter
a_high:				; portpegel ist 1
		btfss	data_1, 0	; ist sollwert=1 ?
		return			; low-high flanke
a_weiter:
		decfsz	cycl_1,f	
		goto	a_1	
		return			; keine flanke gefunden

;**************************************************************
; zeitverzgerung um ein viertelbit = 444,5 us ca. 1100 takte (10 MHz)
;						445 takte  (04 MHz)
;
; zeitverzgerung um ein halbbit    = 889 us   ca. 2200 takte (10 MHz)
;						889 takte  (04 MHz)
;**************************************************************
pause:						;2ms fr 45
		movlw	D'45'
		goto	l_0
pause_l:					;ca 12ms fr 255
		movlw	D'255'
		goto	l_0
viertelbit:
		movlw	D'11'		; 11 x (10 MHz)	
;		movlw	D'9'		; 9 x  ( 4 MHz)
		goto	l_0
halbbit:movlw	D'22'		; 22 x (10 MHz)
;		movlw	D'18'		; 18 x ( 4 MHz)
l_0:	movwf	cycl_1
l_1:	movlw	D'32'		; 100 takte (10 MHz)
;		movlw	D'15'		; 49 takte  ( 4 MHz)
		movwf	cycl_2
l_2:	decfsz	cycl_2,f	
		goto	l_2

		decfsz	cycl_1,f	
		goto	l_1	
		return


; ****************************************************************************
; LED Routinen


setLED:
		btfsc	STOP	; stop 
		return
				
;---------------------------------
		movlw	0x00	; fading
		subwf	mode,w
		bnz		mode1
			
		DEC16	counterL
		bz		mode0a
		
		
		call	setRed		; Farben wg. Helligkeit hier setzen
		call	setGreen
		goto	setBlue	

mode0a:	movlw	0x10
		movwf	counterH
		movlw	0xff
		movwf	counterL

		goto	fading
	

;---------------------------------
mode1:	movlw	0x01		; nur blau
		subwf	mode,w
		bnz		mode2

		movlw	0x00
		movwf	_Green
		movwf	_Red
		
		movfw	max
		movwf	_Blue
	
		call	setRed
		call	setGreen
		goto	setBlue	
		

;---------------------------------
mode2:	movlw	0x02		; nur gruen
		subwf	mode,w
		bnz		mode3

		movlw	0x00
		movwf	_Blue
		movwf	_Red
		
		movfw	max
		movwf	_Green
	
		call	setRed
		call	setBlue
		goto	setGreen	


;---------------------------------
mode3:	movlw	0x03		; nur rot
		subwf	mode,w
		bnz		mode4

		movlw	0x00
		movwf	_Green
		movwf	_Blue
		
		movfw	max
		movwf	_Red
		
		call	setBlue
		call	setGreen
		goto	setRed	

;---------------------------------
mode4:	movlw	0x04		; rot/gruen	
		subwf	mode,w
		bnz		mode5
		
		movlw	0x00
		movwf	_Blue
		
		movfw	max
		movwf	_Green
		movwf	_Red
		
		call	setBlue
		call	setGreen
		goto	setRed	

   
;---------------------------------
mode5:	movlw	0x05		; rot/blau	
		subwf	mode,w
		bnz		mode6

		movlw	0x00
		movwf	_Green
		
		movfw	max
		movwf	_Blue
		movwf	_Red

		call	setGreen
		call	setRed
		goto	setBlue	


;---------------------------------
mode6:	movlw	0x06	; blau/gruen	
		subwf	mode,w
		bnz		mode7


		movlw	0x00
		movwf	_Red
		
		movfw	max
		movwf	_Blue
		movwf	_Green

		call	setRed
		call	setGreen
		goto	setBlue	


;---------------------------------
mode7:	movlw	0x07		; weiss	
		subwf	mode,w
		bnz		mode8

		movfw	max
		movwf	_Red
		movwf	_Blue
		movwf	_Green

		goto	setAllColors


;---------------------------------
mode8:	movlw	0x08		; langsames fading
		subwf	mode,w
		bnz		mode9

		DEC16	counterL
		btfsc	STATUS,Z
		goto	mode8a
			
		call	setRed		; Farben wg. Helligkeit hier setzen
		call	setGreen
		goto	setBlue	

mode8a:	movlw	0x00
		movwf	counterH
		movlw	0x80
		movwf	counterL

		goto	fading

;---------------------------------
mode9:	movlw	0x09		; schnelles fading
		subwf	mode,w
		bnz		mode10

		goto	fading

;---------------------------------
mode10:
		

;---------------------------------
mode11:
  	 
  	 
; .....  	 

;---------------------------------
mode99:	movlw	.99			; alles aus
		subwf	mode,w
		bnz		mode_end
		movlw	0x00
		movwf	_Green
		movwf	_Blue
		movwf	_Red


;---------------------------------
setAllColors:
		call	setRed
		call	setGreen
		goto	setBlue	

mode_end:
		clrf	mode		; mode hatte falschen Wert
		return
;-------------------------------------------------------------------------------
fading:
;		RGB
;		  x
;		 xx
;		xxx
;		xx
;		x
;		x x
;		  x
;		 xx
;		 x 
;		xx 
;		x 
		
; in state steht der wert
		movlw	0x0f				; begrenzen
		andwf	state,f
				 		
		movlw	HIGH(fading_table)	;Highteil von tabelle holen
		movwf	PCLATH				;und nach PCLATH damit
		movlw	LOW(fading_table)	;Lowteil von Tabelle holen
		addwf	state,w
		btfsc	STATUS,C			; berlauf ?
		incf	PCLATH,f			; ja um eins erhhen
		
		movwf	PCL					; Jump		
		
fading_table:
		goto	fadeBlueOn
		goto	fadeGreenOn
		goto	fadeRedOn			
		goto	fadeBlueOff
		goto	fadeGreenOff
		goto	fadeBlueOn	
		goto	fadeRedOff	
		goto	fadeGreenOn
		goto	fadeBlueOff
		goto	fadeRedOn
		goto	fadeGreenOff
		goto	clrState
		goto	clrState
		goto	clrState
		goto	clrState	

		goto	clrState

clrState:		
		clrf	state
		return	 
	

; ----------------------------------------------------------------------------
; fading
	
fadeBlueOn:	
		movfw	_Blue
		subwf	max,w
		bnc		fadeBlueOnToHigh	; Wert zu hoch
		bz		nextState			; Wert gleich
		incf	_Blue,f
		goto	setBlue
	

fadeBlueOnToHigh:
		decf	_Blue,f
		return
	

fadeBlueOff:
		movlw	0
		subwf	_Blue,w
		bz		nextState
		decf	_Blue,f
		goto	setBlue
	

;--------------------------	
fadeGreenOn:	
		movfw	_Green
		subwf	max,w
		bnc		fadeGreenOnToHigh	; Wert zu hoch
		bz		nextState			; Wert gleich
		incf	_Green,f
		goto	setGreen
	

fadeGreenOnToHigh:
		decf	_Green,f
		return
	

fadeGreenOff:
		movlw	0
		subwf	_Green,w
		bz		nextState
		decf	_Green,f
		goto	setGreen

	
;--------------------------	
fadeRedOn:	
		movfw	_Red
		subwf	max,w
		bnc		fadeRedOnToHigh	; Wert zu hoch
		bz		nextState			; Wert gleich
		incf	_Red,f
		goto	setRed
	

fadeRedOnToHigh:
		decf	_Red,f
		return
	

fadeRedOff:
		movlw	0
		subwf	_Red,w
		bz		nextState
		decf	_Red,f
		goto	setRed
	

;--------------------------	
nextState:
		incf	state,f
		return


; ******************************************************************************
; einzelne Farbwerte setzen

setBlue:
		movfw	_Blue				; Variablen Wert Low 2 Bit holen
		movwf	TEMP
		call	getTableValueL
		movwf	TEMP				; neuer Wert aus Tabelle
			
		bsf    	STATUS,   RP0      	; select bank 1
		btfss	TEMP,0				; die 2 Bits setzen
		bcf		CCP3CON,4
		btfsc	TEMP,0
		bsf		CCP3CON,4

		btfss	TEMP,1
		bcf		CCP3CON,5
		btfsc	TEMP,1
		bsf		CCP3CON,5
		bcf     STATUS,   RP0      	; select bank 0 

		movfw	_Blue				; Variablen Wert holen
		movwf	TEMP
		call	getTableValueH
 									; neuer Wert aus Tabelle
		bsf    	STATUS,   RP0      	; select bank 1
		movwf	CCPR3L
		bcf     STATUS,   RP0      	; select bank 0 
		return


;--------------------------	
setGreen:
		movfw	_Green
		movwf	TEMP
		call	getTableValueL
		movwf	TEMP

		btfss	TEMP,0
		bcf		CCP1CON,4
		btfsc	TEMP,0
		bsf		CCP1CON,4
				
		btfss	TEMP,1
		bcf		CCP1CON,5
		btfsc	TEMP,1
		bsf		CCP1CON,5
		
		movfw	_Green
		movwf	TEMP
		call	getTableValueH
			
		movwf	CCPR1L
		return
		
;--------------------------	
setRed:
		movfw	_Red
		movwf	TEMP
		call	getTableValueL
		movwf	TEMP

		btfss	TEMP,0
		bcf		CCP2CON,4
		btfsc	TEMP,0
		bsf		CCP2CON,4
			
		btfss	TEMP,1
		bcf		CCP2CON,5
		btfsc	TEMP,1
		bsf		CCP2CON,5
 
 	
		movfw	_Red
		movwf	TEMP
		call	getTableValueH
	
		movwf	CCPR2L
		return
		
; ******************************************************************************
getTableValueH:
		movlw	0x3f
		subwf	TEMP,w				; nur 64 Werte !
		bnc		gh0
		movlw	0x3f
		movwf	TEMP
gh0:
									; wenn TEMP > max dann max nehmen
		movfw	TEMP
		subwf	max,w
		bc		gh1			 
		movfw	max
		movwf	TEMP
		
gh1:    movlw	HIGH(tableH)		;Highteil von tabelle holen
		movwf	PCLATH				;und nach PCLATH damit
		movlw	LOW(tableH)			;Lowteil von Tabelle holen
		addwf	TEMP,w				; Offset dazu
		btfsc	STATUS,C			; berlauf ?
		incf	PCLATH,f			; ja um eins erhhen
		movwf	PCL					; Absprung
		
; ******************************************************************************
getTableValueL:
		movlw	0x3f
		subwf	TEMP,w				; nur 64 Werte !
		bnc		gl0
		movlw	0x3f
		movwf	TEMP
gl0:			
									; wenn TEMP > max dann max nehmen
		movfw	TEMP
		subwf	max,w
		bc		gl1			 
		movfw	max
		movwf	TEMP
gl1:
		movlw	HIGH(tableL)		;Highteil von tabelle holen
		movwf	PCLATH				;und nach PCLATH damit
		movlw	LOW(tableL)			;Lowteil von Tabelle holen
		addwf	TEMP,w				; Offset dazu
		btfsc	STATUS,C			; berlauf ?
		incf	PCLATH,f			; ja um eins erhhen
		movwf	PCL					; Absprung	



; ******************************************************************************
; Wait Routinen

WaitMs1:
    	MOVLW 	.1
    	goto	WaitMs

WaitMs5:
    	MOVLW 	.5
    	goto	WaitMs

WaitMs10:
    	MOVLW 	.10
    	goto	WaitMs

WaitMs50:
    	MOVLW 	.50
    	goto	WaitMs

WaitMs100:
    	MOVLW 	.100
    	goto	WaitMs

WaitMs250:
	   	MOVLW 	.250
    	goto	WaitMs
    	

WaitMs500:
	   	call	WaitMs250
		goto	WaitMs250
    	
WaitMs1000:
		call	WaitMs500
		goto	WaitMs500

WaitMs2000:
		call	WaitMs1000
		goto	WaitMs1000


WaitMs:
    	MOVWF R0L
    	CLRF R0H
	   	goto W001


; Waitms Routine
W001:	MOVF R0L,F
    	BTFSC STATUS,Z
    	GOTO W002
    	CALL W003
    	DECF R0L,F
    	NOP
    	NOP
    	NOP
    	NOP
    	NOP
    	GOTO W001
W002:	MOVF R0H,F
    	BTFSC STATUS,Z
    	RETURN
    	CALL W003
    	DECF R0H,F
    	DECF R0L,F
    	GOTO W001
W003:	MOVLW 0x0C
    	MOVWF R2H
W004:	DECFSZ R2H,F
	   	GOTO W004
    	NOP
    	NOP
    	MOVLW 0x62
	   	MOVWF R1L
W005:	DECFSZ R1L,F
    	GOTO W006
    	CALL W007
    	CALL W007
    	NOP
    	NOP
    	RETURN
W006:	CALL W007
    	GOTO W005
W007:	MOVLW 0x0D
    	MOVWF R2L
W008:	DECFSZ R2L,F
 	  	GOTO W008
    	NOP
    	RETURN

    	




; *** Begin I2C Data Transfer Sequences ***

I2CWrite:
	; unklar, warum das bentigt wird !
	bsf     STATUS, RP0         ; Bank 1 
	movlw   .25               	; clock  
	movwf   SSPADD              ; 100kHz I2C clock	
	bcf     STATUS, RP0         ; Bank 0 
 ; --------------------------------------------------------
 
								; Send START condition and wait for it to complete
	BANKSEL SSPCON2 			; BANK 1
	bsf 	SSPCON2,SEN 		; Generate START Condition
	call 	WaitMSSP 			; Wait for I2C operation to complete

	
; Send and Check CONTROL BYTE, wait for it to complete

	movlw 	LC01CTRLIN 			; Load CONTROL BYTE (input mode)
	call 	Send_I2C_Byte 		; Send Byte
	call 	WaitMSSP 			; Wait for I2C operation to complete
	BANKSEL SSPCON2
	btfsc 	SSPCON2,ACKSTAT 		; Check ACK Status bit to see if I2C
	goto 	I2CFail 			; failed, skipped if successful

 

; Send and Check ADDRESS BYTE, wait for it to complete

	movfw 	LC01ADDR 			; Load Address Byte
	call 	Send_I2C_Byte 		; Send Byte
	call 	WaitMSSP 			; Wait for I2C operation to complete
	BANKSEL SSPCON2
	btfsc 	SSPCON2,ACKSTAT 	; Check ACK Status bit to see if I2C
	goto 	I2CFail 			; failed, skipped if successful

; Send and Check DATA BYTE, wait for it to complete

	movfw 	LC01DATA 			; Load Data Byte
	call 	Send_I2C_Byte 		; Send Byte
	call 	WaitMSSP 			; Wait for I2C operation to complete
	BANKSEL SSPCON2
	btfsc 	SSPCON2,ACKSTAT 	; Check ACK Status bit to see if I2C
	goto 	I2CFail 			; failed, skipped if successful

; Send and Check the STOP condition, wait for it to complete

	BANKSEL SSPCON2
	bsf 	SSPCON2,PEN 		; Send STOP condition
	call 	WaitMSSP 			; Wait for I2C operation to complete

	return

; The WRITE has now completed successfully. Begin the Read Sequence




I2CRead:
 ; unklar, warum das bentigt wird !
	bsf     STATUS, RP0         ; Bank 1 
	movlw   .25               	; clock  
	movwf   SSPADD              ; 100kHz I2C clock	
	bcf     STATUS, RP0         ; Bank 0 
 ; --------------------------------------------------------

								; Send RESTART condition and wait for it to complete
	BANKSEL SSPCON2
	bsf 	SSPCON2,RSEN 		; Generate RESTART Condition
	call 	WaitMSSP 			; Wait for I2C operation to complete
								; Send and Check CONTROL BYTE, wait for it to complete
	movlw 	LC01CTRLIN 			; Load CONTROL BYTE (input)
	call 	Send_I2C_Byte 		; Send Byte
	call 	WaitMSSP 			; Wait for I2C operation to complete
								; Now check to see if I2C EEPROM is ready
	BANKSEL SSPCON2
	btfsc 	SSPCON2,ACKSTAT 	; Check ACK Status bit to see if I2C
	goto 	I2CRead 			; ACK Poll waiting for EEPROM write to complete
								; Send and Check ADDRESS BYTE, wait for it to complete
	movfw 	LC01ADDR 			; Load ADDRESS BYTE
	call 	Send_I2C_Byte 		; Send Byte
	call 	WaitMSSP 			; Wait for I2C operation to complete
	BANKSEL SSPCON2
	btfsc 	SSPCON2,ACKSTAT 	; Check ACK Status bit to see if I2C
	goto 	I2CFail 			; failed, skipped if successful
								; Send REPEATED START condition and wait for it to complete
	bsf 	SSPCON2,RSEN 		; Generate REPEATED START Condition
	call 	WaitMSSP 			; Wait for I2C operation to complete
	
; Send and Check CONTROL BYTE (out), wait for it to complete

	movlw 	LC01CTRLOUT 		; Load CONTROL BYTE (output)
	call 	Send_I2C_Byte 		; Send Byte
	call 	WaitMSSP 			; Wait for I2C operation to complete
	BANKSEL SSPCON2
	btfsc 	SSPCON2,ACKSTAT 	; Check ACK Status bit to see if I2C
	goto 	I2CFail 			; failed, skipped if successful
		
; Switch MSSP module to I2C Receive mode

	bsf SSPCON2,RCEN 			; Enable Receive Mode (I2C)
	
; Get the DATA BYTE and wait for it to complete. Data is in SSPBUF when done.
; The receive mode is disabled at end automatically by the MSSP module.
	call WaitMSSP ; Wait for I2C operation to complete

; Send NACK bit for Acknowledge Sequence
	BANKSEL SSPCON2
	bsf 	SSPCON2,ACKDT 		; ACK DATA to send is 1, which is NACK.
	bsf 	SSPCON2,ACKEN 		; Send ACK DATA now.
	
; Once ACK or NACK is sent, the ACKEN is automatically cleared by the MSSP
; Send and Check the STOP condition and wait for it to complete.

	bsf 	SSPCON2,PEN 		; Send STOP condition
	call 	WaitMSSP 			; Wait for I2C operation to complete
	
; I2C Write and Read have both finished, the value is output on LEDs.
	BANKSEL SSPBUF 				; BANK 0
	movf 	SSPBUF,W 			; Get data from SSPBUF into W register
;	movwf 	PORTB 				; Output W register to LEDs on PORTB
	
; Program has finished and completed successfully.
	return
	goto 	$ 					; Wait forever at this location

; *** SUBROUTINES & ERROR HANDLERS ***
; I2C Operation Failed code sequence - This will normally not happen,
; but if it does, a STOP is sent and the entire code is tried again.

I2CFail:
	return
	BANKSEL SSPCON2
	bsf 	SSPCON2,PEN 		; Send STOP condition
	call 	WaitMSSP 			; Wait for I2C operation to complete
	BANKSEL PORTB 				; BANK 0
	movlw 	0xFF 				; Turn on all LEDs on PORTB
	movwf 	PORTB 				; to show error condition
	goto 	$ 					; Wait forever at this location
	
; This routine sends the W register to SSPBUF, thus transmitting a byte.
; Then, the SSPIF flag is checked to ensure the byte has been sent successfully.
; When that has completed, the routine exits, and executes normal code.

Send_I2C_Byte:
	BANKSEL SSPBUF 				; BANK 0
	movwf 	SSPBUF 				; Get value to send from W, put in SSPBUF
	retlw 	0 					; Done, Return 0
	
; This routine waits for the last I2C operation to complete.
; It does this by polling the SSPIF flag in PIR1.
WaitMSSP:
	BANKSEL PIR1 			; BANK 0
	btfss 	PIR1,SSPIF 		; Check if done with I2C operation
	goto 	$-1 			; I2C module is not ready yet
	bcf 	PIR1,SSPIF 		; I2C module is ready, clear flag.
	Retlw 	0 				; Done, Return 0



; ******************************************************************************
; 1. Tabelle 64 8 Bit High Werte HHHHHHHLL

tableH:
   retlw .0
   retlw .0
   retlw .0
   retlw .0
   retlw .0
   retlw .0
   retlw .0
   retlw .0
   retlw .0
   retlw .0
   retlw .0
   retlw .1
   retlw .1
   retlw .1
   retlw .1
   retlw .1
   retlw .1
   retlw .1
   retlw .2
   retlw .2
   retlw .2
   retlw .2
   retlw .3
   retlw .3
   retlw .3
   retlw .4
   retlw .4
   retlw .5
   retlw .5
   retlw .6
   retlw .7
   retlw .8
   retlw .9
   retlw .10
   retlw .11
   retlw .12
   retlw .13
   retlw .15
   retlw .17
   retlw .19
   retlw .21
   retlw .23
   retlw .26
   retlw .29
   retlw .32
   retlw .36
   retlw .40
   retlw .45
   retlw .50
   retlw .56
   retlw .62
   retlw .69
   retlw .77
   retlw .86
   retlw .96
   retlw .107
   retlw .119
   retlw .133
   retlw .148
   retlw .165
   retlw .184
   retlw .206
   retlw .229
   retlw .255
   
   ;sicherheitshalber
moreH	macro
	local a = 0
	while a < 100
	retlw .255
	
a = a +1
	endw
	endm
	
	moreH	

; ******************************************************************************
; 1. Tabelle 64 8 Bit Low Werte hhhhhhhhLL 
tableL:
   retlw .0
   retlw .1
   retlw .1
   retlw .2
   retlw .2
   retlw .2
   retlw .2
   retlw .2
   retlw .3
   retlw .3
   retlw .3
   retlw .0
   retlw .0
   retlw .1
   retlw .1
   retlw .2
   retlw .2
   retlw .3
   retlw .0
   retlw .1
   retlw .2
   retlw .3
   retlw .0
   retlw .1
   retlw .3
   retlw .1
   retlw .3
   retlw .1
   retlw .3
   retlw .2
   retlw .1
   retlw .0
   retlw .0
   retlw .0
   retlw .0
   retlw .1
   retlw .3
   retlw .1
   retlw .0
   retlw .0
   retlw .1
   retlw .2
   retlw .1
   retlw .1
   retlw .3
   retlw .2
   retlw .2
   retlw .1
   retlw .2
   retlw .1
   retlw .2
   retlw .3
   retlw .3
   retlw .2
   retlw .2
   retlw .2
   retlw .3
   retlw .2
   retlw .3
   retlw .3
   retlw .3
   retlw .0
   retlw .2
   retlw .3



;sicherheitshalber
moreL	macro
	local a = 0
	while a < 100
	retlw .3
	
a = a +1
	endw
	endm
	
	moreL	


   


  end 
